#include <dos.h>
#include <math.h>
#include <stdio.h>
#include <conio.h>

#define VOL	3	// 0..8, 8=loudest
#define FRAMES_BUFFER 10
#define OFFSET (32768 - (1<<(7+VOL)))

int (*buf)[1152*2];
void main(int argc, char **argv)
{
	int vol = VOL;
	if(argc < 2) return;
	FILE *f = fopen(argv[1], "rb");
	if(!f) return;
	buf = new int[FRAMES_BUFFER][1152*2];
	fseek(f, 64, SEEK_SET);	// skip wave header
	unsigned int frames_read = fread(buf, 1152*2*2, FRAMES_BUFFER, f);
	outportb(0x378, 0);

	while(frames_read)
	{
		if(!(inportb(0x3da) & 0x10))
		{
			int offset = 32768 - (1<<(7+vol));
			if(offset > 0) offset -= 128;
			for(int n=0; n<1152*2; n++) outport(0x378, (buf[FRAMES_BUFFER-frames_read][n]>>(8-vol))-offset);
			if(!--frames_read) frames_read = fread(buf, 1152*2*2, FRAMES_BUFFER, f);
		}
		if(kbhit())
		{
			int ch = getch();
			if(ch == 0x1b) break;
			else switch(ch)
			{
				case 0x50: vol -= vol > 0; break;
				case 0x48: vol += vol < 8; break;
				case 0x4b: fseek(f, -44100l*4, SEEK_CUR); break;
				case 0x4d: fseek(f, 44100l*4, SEEK_CUR); break;
			}
		}
	}
	fclose(f);
	delete buf;
	outportb(0x378, 0);
}